library(slam)
library(gurobi)
library(ggplot2)

getScalingMatrix <- function(vector) {
  x1 = vector[1]
  x2 = vector[2]
  x3 = vector[3]
  x4 = vector[4]
  x5 = vector[5]
  x6 = vector[6]
  
  scalingRestrictionsVector = c()
  if(x1 == 0) {
    scalingRestrictionsVector = c(1,0,0,0,0,0)
  } else if (x2 != 0) {
    scalingRestrictionsVector = c(1/x1,-1/x2,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(1/x1,0,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(0,0,0,0,0,0)
  }
  
  if(x2 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,1,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,1/x2,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,1/x2,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,1/x2,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,1/x2,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector, 0,0,0,0,0,0)
  }
  
  
  if(x3 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,1,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,1/x3,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,1/x3,0,-1/x5,0)
  } else if (x6 != 0) { 
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,1/x3,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }
  
  
  if(x4 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,1,0,0)
  } else if (x5 != 0) { 
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,1/x4,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,1/x4,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }
  
  
  if(x5 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,0,1,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,0,1/x5,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }
  
  
  if(x6 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
                                  0,0,0,0,0,1)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }
  
  scalingRestrictionsMatrix <- matrix(scalingRestrictionsVector,
                                      nrow=6,ncol=6,byrow=T)
  return(scalingRestrictionsMatrix)
}

#VersionFolder should be adjusted to fit the path of the output
incrementFactor = 1.5
numberOfExpansions = 100

#Full dataset
startCap = 170
versionFolder = "../R_Output_V5/"
userCountVector = c(139, 5805, 5913, 4003, 6057, 5093)

#Adjust the path to the file segmentMatrixV5.csv
indata = read.csv("../output/segmentMatrixV5.csv", head = TRUE, sep = ",")
indata = indata[complete.cases(indata), ]
uniqeUserId = unique(indata[,2])

numberOfIncrementedFixed = c()
numberOfIncrementedScaling = c()
numberOfIncrementedOptimized = c()
maxVector43 = c()
maxVector15 = c()
maxVector2 = c()
gurobiIndataScaling43 = list()
gurobiIndataScaling43$obj = userCountVector
gurobiIndataScaling43$modelsense = "max"
gurobiIndataScaling43$A = as.matrix(indata[,4:9])
size = nrow(gurobiIndataScaling43$A)
capVector43 = rep(startCap, size)
capVector15 = rep(startCap, size)   
capVector2 = rep(startCap, size)     
gurobiIndataScaling43$sense = rep("<=", size)

gurobiIndataScaling15 = gurobiIndataScaling43
gurobiIndataScaling2 = gurobiIndataScaling43

params = list(OutputFlag=0)
dfCellUpgraded = matrix(nrow = 100, ncol = 3)

sense_additional = rep("=",6)
noScalingRestrictionsRHSaddition = c(0,0,0,0,0,0)

for(y in 1:100) {
  cat("\ny: ",y)
  if(y == 1) {
    gurobiIndataScaling43$rhs = capVector43
    result43 = gurobi(gurobiIndataScaling43, params)
    gc()
    gurobiIndataScaling15$rhs = capVector15
    result15 = gurobi(gurobiIndataScaling15, params)
    gc()
    gurobiIndataScaling2$rhs = capVector2
    result2 = gurobi(gurobiIndataScaling2, params)
    gc()
    
    scalingRestrictionsMatrix = getScalingMatrix(result43$x)
    gurobiIndataScaling43$A = rbind(as.matrix(indata[,4:9]), 
                                  scalingRestrictionsMatrix)
    size = nrow(gurobiIndataScaling43$A) - nrow(scalingRestrictionsMatrix)
    capVector43 = c(capVector43, noScalingRestrictionsRHSaddition)
    gurobiIndataScaling43$sense = c(rep("<=", size), sense_additional)
    
    scalingRestrictionsMatrix = getScalingMatrix(result15$x)
    gurobiIndataScaling15$A = rbind(as.matrix(indata[,4:9]), 
                                    scalingRestrictionsMatrix)
    size = nrow(gurobiIndataScaling15$A) - nrow(scalingRestrictionsMatrix)
    capVector15 = c(capVector15, noScalingRestrictionsRHSaddition)
    gurobiIndataScaling15$sense = c(rep("<=", size), sense_additional)
    
    scalingRestrictionsMatrix = getScalingMatrix(result2$x)
    gurobiIndataScaling2$A = rbind(as.matrix(indata[,4:9]), 
                                    scalingRestrictionsMatrix)
    size = nrow(gurobiIndataScaling2$A) - nrow(scalingRestrictionsMatrix)
    capVector2 = c(capVector2, noScalingRestrictionsRHSaddition)
    gurobiIndataScaling2$sense = c(rep("<=", size), sense_additional)
    
  } else {
    gurobiIndataScaling43$rhs = capVector43
    result43 = gurobi(gurobiIndataScaling43, params)
    gc()
    gurobiIndataScaling15$rhs = capVector15
    result15 = gurobi(gurobiIndataScaling15, params)
    gc()
    gurobiIndataScaling2$rhs = capVector2
    result2 = gurobi(gurobiIndataScaling2, params)
    gc()
    
    scalingRestrictionsMatrix = getScalingMatrix(result43$x)
    size = dim(gurobiIndataScaling43$A)[1]
    gurobiIndataScaling43$A = rbind(gurobiIndataScaling43$A[1:(size-6),], 
                                  scalingRestrictionsMatrix)
    
    scalingRestrictionsMatrix = getScalingMatrix(result15$x)
    size = dim(gurobiIndataScaling15$A)[1]
    gurobiIndataScaling15$A = rbind(gurobiIndataScaling15$A[1:(size-6),], 
                                    scalingRestrictionsMatrix)

    
    scalingRestrictionsMatrix = getScalingMatrix(result2$x)
    size = dim(gurobiIndataScaling2$A)[1]
    gurobiIndataScaling2$A = rbind(gurobiIndataScaling2$A[1:(size-6),], 
                                    scalingRestrictionsMatrix)
  }
  
  maxVector43 = c(maxVector43, result43$objval)
  maxVector15 = c(maxVector15, result15$objval)
  maxVector2 = c(maxVector2, result2$objval)
  
  incrementedCellIdsFixed = c()
  incrementedCellIdsScaling = c()
  incrementedCellIdsOptimized = c()
  
  fixedUpgraded = FALSE
  scalingUpgraded = FALSE
  optimizedUpgraded = FALSE
  for(i in 1:length(uniqeUserId)) {
    firstOffset = 2016 * (i-1) + 1
    lastOffset = 2016 * i
    subsetResult43 = result43$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult43) && !fixedUpgraded) {
      capVector43[firstOffset:lastOffset] = capVector43[firstOffset] * (4/3)
      incrementedCellIdsFixed = c(incrementedCellIdsFixed, i)
      upgradedFixed = i
      fixedUpgraded = TRUE
    }
    subsetResult15 = result15$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult15) && !scalingUpgraded) {
      capVector15[firstOffset:lastOffset] = capVector15[firstOffset] * 1.5
      incrementedCellIdsScaling = c(incrementedCellIdsScaling, i)
      upgradedScaling = i
      scalingUpgraded = TRUE
    }
    subsetResult2 = result2$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult2) && !optimizedUpgraded) {
      capVector2[firstOffset:lastOffset] = capVector2[firstOffset] * 2
      incrementedCellIdsOptimized = c(incrementedCellIdsOptimized, i)
      upgradedOptimized = i
      optimizedUpgraded = TRUE
    }
    if(fixedUpgraded && scalingUpgraded && optimizedUpgraded) {
      break
    }
  }
  numberOfIncrementedFixed = c(numberOfIncrementedFixed, length(incrementedCellIdsFixed))
  numberOfIncrementedScaling = c(numberOfIncrementedScaling, length(incrementedCellIdsScaling))
  numberOfIncrementedOptimized = c(numberOfIncrementedOptimized, length(incrementedCellIdsOptimized))
  
  cat("\nUpgraded 4/3: ",upgradedFixed)
  cat(" CellId: ")
  for(k in 1:length(indata)) { cat(" ", indata[(2016*(upgradedFixed-1)+1),k])}
  cat("\nUpgraded 1.5: ",upgradedScaling)
  for(k in 1:length(indata)) { cat(" ", indata[(2016*(upgradedScaling-1)+1),k])}
  cat("\nUpgraded 2: ",upgradedOptimized)
  for(k in 1:length(indata)) { cat(" ", indata[(2016*(upgradedOptimized-1)+1),k])}
  dfCellUpgraded[y,1] = as.character(indata[(2016*(upgradedFixed-1)+1), 2])
  dfCellUpgraded[y,2] = as.character(indata[(2016*(upgradedScaling-1)+1), 2])
  dfCellUpgraded[y,3] = as.character(indata[(2016*(upgradedOptimized-1)+1), 2])
  
  gc()
}

xValues = 0:100

gurobiIndataScaling43$rhs = capVector43
result43 = gurobi(gurobiIndataScaling43, params)
gc()
gurobiIndataScaling15$rhs = capVector15
result15 = gurobi(gurobiIndataScaling15, params)
gc()
gurobiIndataScaling2$rhs = capVector2
result2 = gurobi(gurobiIndataScaling2, params)
gc()
    
maxVector43 = c(maxVector43, result43$objval)
maxVector15 = c(maxVector15, result15$objval)
maxVector2 = c(maxVector2, result2$objval)    


df43 = data.frame(xValues, maxVector43)
df15 = data.frame(xValues, maxVector15)
df2 = data.frame(xValues, maxVector2)

name = paste(versionFolder, "scalingDifferentFactors.tiff", sep="")
counter = 0

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "scalingDifferentFactors", counter, ".tiff", sep = "")
  counter = counter + 1
}

#normalize scale between filtered and full dataset plot
yMinMax = c(0,150000)
xMinMax = c(0,100)
point = data.frame(xMinMax, yMinMax)

#tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
p = ggplot(data=NULL, xlab="") + labs(x = "Expansions", y ="Capacity") 
p = p + geom_step(linetype="dotted", data=df43, aes(xValues, maxVector43), colour="green")
p = p + geom_step(data=df15, aes(xValues, maxVector15), colour="green")
p = p + geom_step(linetype="dotted", data=df2, aes(xValues, maxVector2), colour="green")
p = p + geom_point(data = point, aes(xMinMax, yMinMax), size = 0.1, color = "white")
p = p + scale_y_continuous()
ggsave(name, plot=p)


un = union(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nUnion 4/3;3/2", length(un))
cat("\nUnion 4/3;2", length(union(dfCellUpgraded[,1], dfCellUpgraded[,3])))
cat("\nUnion 3/2;2", length(union(dfCellUpgraded[,2], dfCellUpgraded[,3])))
un = union(un, dfCellUpgraded[,3])
cat("\nUnion 4/3;3/2;2", length(un))

inter = intersect(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nIntersect 4/3,3/2 ", length(inter))
cat("\nIntersect 4/3,2 ", length(intersect(dfCellUpgraded[,1], dfCellUpgraded[,3])))
cat("\nIntersect 3/2,2 ", length(intersect(dfCellUpgraded[,2], dfCellUpgraded[,3])))
inter = intersect(inter, dfCellUpgraded[,3])
cat("\nIntersect 4/3,3/2,2 ", length(inter))

cat("Unique 4/3: ", length(unique(dfCellUpgraded[,1])))
cat("Unique 3/2: ", length(unique(dfCellUpgraded[,2])))
cat("Unique 2: ", length(unique(dfCellUpgraded[,3])))
