library(slam)
library(gurobi)
library(ggplot2)

#Settings

numberOfExpansions = 100

#Path for output can be adjusted here
#Full dataset
incrementFactor = 1.5
startCap = 170
versionFolder = "../R_Output_V5/"
userCountVector = c(139, 5805, 5913, 4003, 6057, 5093)

#Indata should be adjusted to fit the path of the segmentMatrix file
indata = read.csv("../output/segmentMatrixV5.csv", head = TRUE, sep = ",")
indata = indata[complete.cases(indata), ]
uniqeUserId = unique(indata[,2])

noScalingRestrictionsVector = c(1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1)
noScalingRestrictionsMatrix = matrix(noScalingRestrictionsVector,nrow=5,ncol=6,byrow=T)
noScalingRestrictionsRHSaddition = c(0,0,0,0,0)
sense_additional = c('=','=','=','=','=')

numberOfIncrementedFixed = c()
maxVector43 = c()
maxVector15 = c()
maxVector2 = c()
incrementedCellIdsFixed = c()
incrementedCellIdsScaling = c()
incrementedCellIdsOptimized = c()
numberOfIncrementedFixed = c()
numberOfIncrementedScaling = c()
numberOfIncrementedOptimized = c()
gurobiIndataFixed = list()
gurobiIndataFixed$obj = userCountVector
gurobiIndataFixed$modelsense = "max"
gurobiIndataFixed$A = rbind(as.matrix(indata[,4:9]), noScalingRestrictionsMatrix)
size = nrow(gurobiIndataFixed$A) - nrow(noScalingRestrictionsMatrix)
capVector43 = c(rep(startCap, size), noScalingRestrictionsRHSaddition)
capVector15 = c(rep(startCap, size), noScalingRestrictionsRHSaddition)     
capVector2 = c(rep(startCap, size), noScalingRestrictionsRHSaddition)     
gurobiIndataFixed$sense = c(rep("<=", size), sense_additional)

params = list(OutputFlag=0)
dfCellUpgraded = matrix(nrow = 100, ncol = 3)

for(y in 1:100) {
  cat("\n",y)
  gurobiIndataFixed$rhs = capVector43
  result43 = gurobi(gurobiIndataFixed, params)
  gc()
  gurobiIndataFixed$rhs = capVector15
  result15 = gurobi(gurobiIndataFixed, params)
  gc()
  gurobiIndataFixed$rhs = capVector2
  result2 = gurobi(gurobiIndataFixed, params)
  gc()
  
  maxVector43 = c(maxVector43, result43$objval)
  maxVector15 = c(maxVector15, result15$objval)
  maxVector2 = c(maxVector2, result2$objval)
  
  fixedUpgraded = FALSE
  scalingUpgraded = FALSE
  optimizedUpgraded = FALSE
  for(i in 1:length(uniqeUserId)) {
    firstOffset = 2016 * (i-1) + 1
    lastOffset = 2016 * i
    subsetResult43 = result43$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult43) && !fixedUpgraded) {
      capVector43[firstOffset:lastOffset] = capVector43[firstOffset] * (4/3)
      incrementedCellIdsFixed = c(incrementedCellIdsFixed, i)
      upgradedFixed = i
      fixedUpgraded = TRUE
    }
    subsetResult15 = result15$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult15) && !scalingUpgraded) {
      capVector15[firstOffset:lastOffset] = capVector15[firstOffset] * 1.5
      incrementedCellIdsScaling = c(incrementedCellIdsScaling, i)
      upgradedScaling = i
      scalingUpgraded = TRUE
    }
    subsetResult2 = result2$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResult2) && !optimizedUpgraded) {
      capVector2[firstOffset:lastOffset] = capVector2[firstOffset] * 2
      incrementedCellIdsOptimized = c(incrementedCellIdsOptimized, i)
      upgradedOptimized = i
      optimizedUpgraded = TRUE
    }
    if(fixedUpgraded && scalingUpgraded && optimizedUpgraded) {
      break
    }
  }
  numberOfIncrementedFixed = c(numberOfIncrementedFixed, length(incrementedCellIdsFixed))
  numberOfIncrementedScaling = c(numberOfIncrementedScaling, length(incrementedCellIdsScaling))
  numberOfIncrementedOptimized = c(numberOfIncrementedOptimized, length(incrementedCellIdsOptimized))
  
  dfCellUpgraded[y,1] = as.character(indata[(2016*(upgradedFixed-1)+1), 2])
  dfCellUpgraded[y,2] = as.character(indata[(2016*(upgradedScaling-1)+1), 2])
  dfCellUpgraded[y,3] = as.character(indata[(2016*(upgradedOptimized-1)+1), 2])
  
  gc()
}

xValues = 0:100

cat("\n",y)
gurobiIndataFixed$rhs = capVector43
result43 = gurobi(gurobiIndataFixed, params)
gc()
gurobiIndataFixed$rhs = capVector15
result15 = gurobi(gurobiIndataFixed, params)
gc()
gurobiIndataFixed$rhs = capVector2
result2 = gurobi(gurobiIndataFixed, params)
gc()
  
maxVector43 = c(maxVector43, result43$objval)
maxVector15 = c(maxVector15, result15$objval)
maxVector2 = c(maxVector2, result2$objval)
  


df43 = data.frame(xValues, maxVector43)
df15 = data.frame(xValues, maxVector15)
df2 = data.frame(xValues, maxVector2)

name = paste(versionFolder, "fixedDifferentScalingFactors.tiff", sep="")
counter = 0

# Normalize axles in scaling and fixed plots
xMinMax = c(0,100)
yMinMax = c(0,150000)
point = data.frame(xMinMax, yMinMax)

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "fixedDifferentScalingFactors", counter, ".tiff", sep = "")
  counter = counter + 1
}
#tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
p = ggplot(data=NULL, xlab="") + labs(x = "Expansions", y ="Capacity") 
p = p + geom_step(linetype="dotted", data=df43, aes(xValues, maxVector43), colour="red")
p = p + geom_step(data=df15, aes(xValues, maxVector15), colour="red")
p = p + geom_step(linetype="dotted", data=df2, aes(xValues, maxVector2), colour="red")
p = p + geom_point(data = point, aes(xMinMax, yMinMax), size = 0.1, color = "white")
p = p + scale_y_continuous()
ggsave(name, plot=p)


un = union(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nUnion 4/3;3/2", length(un))
cat("\nUnion 4/3;2", length(union(dfCellUpgraded[,1], dfCellUpgraded[,3])))
cat("\nUnion 3/2;2", length(union(dfCellUpgraded[,2], dfCellUpgraded[,3])))
un = union(un, dfCellUpgraded[,3])
cat("\nUnion 4/3;3/2;2", length(un))

inter = intersect(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nIntersect 4/3,3/2 ", length(inter))
cat("\nIntersect 4/3,2 ", length(intersect(dfCellUpgraded[,1], dfCellUpgraded[,3])))
cat("\nIntersect 3/2,2 ", length(intersect(dfCellUpgraded[,2], dfCellUpgraded[,3])))
inter = intersect(inter, dfCellUpgraded[,3])
cat("\nIntersect 4/3,3/2,2 ", length(inter))

cat("Unique 4/3: ", length(unique(dfCellUpgraded[,1]))) 
cat("Unique 3/2: ", length(unique(dfCellUpgraded[,2])))
cat("Unique 2: ", length(unique(dfCellUpgraded[,3])))
