library(slam)
library(gurobi)
library(ggplot2)
library(splines)

incrementFactor = 1.5
startCap = 175
versionFolder = "../R_Output_V5/"
userCountVector = c(139, 5805, 5913, 4003, 6057, 5093)

indata = read.csv("../output/segmentMatrixV5.csv", head = TRUE, sep = ",")
indata = indata[complete.cases(indata), ]

noScalingRestrictionsVector = c(1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1)
noScalingRestrictionsMatrix = matrix(noScalingRestrictionsVector,nrow=5,ncol=6,byrow=T)
noScalingRestrictionsRHSaddition = c(0,0,0,0,0)
sense_additional = c('=','=','=','=','=')

maxVectorFixed = c()
gurobiIndataFixed = list()
gurobiIndataFixed$obj = userCountVector
gurobiIndataFixed$modelsense = "max"
gurobiIndataFixed$A = rbind(as.matrix(indata[,4:9]), noScalingRestrictionsMatrix)
size = nrow(gurobiIndataFixed$A) - nrow(noScalingRestrictionsMatrix)
capVectorFixed = c(rep(startCap, size), noScalingRestrictionsRHSaddition)
gurobiIndataFixed$rhs = capVectorFixed
gurobiIndataFixed$sense = c(rep("<=", size), sense_additional)

biggerThanOneVector = c(1,0,0,0,0,0, 0,1,0,0,0,0, 0,0,1,0,0,0, 0,0,0,1,0,0, 0,0,0,0,1,0, 0,0,0,0,0,1)
biggerThanOneMatrix = matrix(biggerThanOneVector,nrow=6,ncol=6,byrow=T)
biggerThanOneRHS = c(1,1,1,1,1,1)
sense_additional = c('>=', '>=', '>=', '>=', '>=', '>=')

maxVectorBiggerThanOne = c()
gurobiBiggerThanOne = list()
gurobiBiggerThanOne$obj = userCountVector
gurobiBiggerThanOne$modelsense = "max"
gurobiBiggerThanOne$A = rbind(as.matrix(indata[,4:9]), biggerThanOneMatrix)
size = nrow(gurobiBiggerThanOne$A) - nrow(biggerThanOneMatrix)
capVectorBiggerThanOne = c(rep(startCap, size), biggerThanOneRHS)
gurobiBiggerThanOne$rhs = capVectorBiggerThanOne
gurobiBiggerThanOne$sense = c(rep("<=", size), sense_additional)

params = list(OutputFlag=0)

cat("\nLength maxVectorFixed: ", length(maxVectorFixed)) 
cat("\nLength maxVectorBiggerThanOne: ", length(maxVectorBiggerThanOne)) 




for(x in seq(from=10, to=230, by=10)) {
  fixedResult = gurobi(gurobiIndataFixed, params)
  biggerThanOneResult = gurobi(gurobiBiggerThanOne, params)
  
  gurobiBiggerThanOne$rhs = c(rep((startCap+x), size), biggerThanOneRHS)
  gurobiIndataFixed$rhs = c(rep((startCap+x), size), noScalingRestrictionsRHSaddition)
  
  maxVectorFixed = c(maxVectorFixed, fixedResult$objval)
  maxVectorBiggerThanOne = c(maxVectorBiggerThanOne, biggerThanOneResult$objval)
  cat("\n\n ", x)
  cat("\nLength maxVectorFixed: ", length(maxVectorFixed)) 
  cat("\nLength maxVectorBiggerThanOne: ", length(maxVectorBiggerThanOne)) 



}

fixedResult = gurobi(gurobiIndataFixed, params)
biggerThanOneResult = gurobi(gurobiBiggerThanOne, params)

maxVectorFixed = c(maxVectorFixed, fixedResult$objval)
maxVectorBiggerThanOne = c(maxVectorBiggerThanOne, biggerThanOneResult$objval)


cat("\n\nLength maxVectorFixed: ", length(maxVectorFixed)) 
cat("\n\nLength maxVectorBiggerThanOne: ", length(maxVectorBiggerThanOne)) 

xValues = c(165, seq(from=170, to=400, by=10))
percent = c(0, 100*((maxVectorBiggerThanOne/maxVectorFixed) - 1))
dfPercent = data.frame(xValues, percent)

p <- ggplot(dfPercent, aes(x=xValues, y=percent)) + geom_point(colour="Blue") + geom_line() + labs(x="Cell capacity")
filename = paste(versionFolder,"expandingPercent.tiff", sep="")
ggsave(filename, p)
