library(slam)
library(gurobi)
library(ggplot2)

#Settings for filtered data (every second occuring user)
incrementFactor = 1.5
startCap = 210
versionFolder = "../R_Output_V5/"
userCountVector = c(140, 5804, 5912, 4004, 6058, 5094)

indata = read.csv("../output/segmentMatrixV5.csv", head = TRUE, sep = ",")
indata = indata[complete.cases(indata), ]
uniqeUserId = unique(indata[,2])

# Used to calculate number of unique users in a segment. 
#Only needed to be run once
# rawData = read.csv("./lib/V5_mergedSegments.csv", head = TRUE, sep = ",")
# rawData = rawData[complete.cases(rawData), ]
# segments = sort(unique(rawData[,16]))
# userCountVector = c()
# for(i in 1:length(segments)) {
#   filter = segments[i] == rawData[,16]
#   segmentData = rawData[filter, ]
#   userCountVector = c(userCountVector, length(unique(segmentData[,3])))
# }

noScalingRestrictionsVector = c(1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,
0,0,0,0,0,1,-1,0,0,0,0,0,1,-1)
noScalingRestrictionsMatrix = matrix(noScalingRestrictionsVector,nrow=5,
ncol=6,byrow=T)
noScalingRestrictionsRHSaddition = c(0,0,0,0,0)
sense_additional = c('=','=','=','=','=')

#Red line in figures is all variables labled with Fixed
numberOfIncrementedFixed = c()
maxVectorFixed = c()
gurobiIndataFixed = list()
gurobiIndataFixed$obj = userCountVector
gurobiIndataFixed$modelsense = "max"
gurobiIndataFixed$A = rbind(as.matrix(indata[,4:9]), 
noScalingRestrictionsMatrix)
size = nrow(gurobiIndataFixed$A) - nrow(noScalingRestrictionsMatrix)
capVectorFixed = c(rep(startCap, size), noScalingRestrictionsRHSaddition)
gurobiIndataFixed$sense = c(rep("<=", size), sense_additional)

#Green line in figures is all variables labled with Scaling
numberOfIncrementedScaling = c()
maxVectorScaling = c()
gurobiIndataScaling = list()
gurobiIndataScaling$obj = userCountVector
gurobiIndataScaling$modelsense = "max"
gurobiIndataScaling$A = as.matrix(indata[,4:9])
size = nrow(gurobiIndataScaling$A)
capVectorScaling = rep(startCap, size)    
gurobiIndataScaling$sense = rep("<=", size)

#Blue line in figures is all variables labled with Optimized
gurobiOptimize = gurobiIndataScaling
gurobiIndataOptimize = gurobiIndataScaling
numberOfIncrementedOptimized = c()
maxVectorOptimized = c()
capVectorOptimized = rep(startCap, size)

optimizedFixedY = c()
optimizedFixedX = c()

optimizedScalingY = c()
optimizedScalingX = c()

params = list(OutputFlag=0)
dfCellUpgraded = matrix(nrow = 100, ncol = 3)

incrementedDayTimeFixed = c()
incrementedDayTimeScaling = c()
incrementedDayTimeOptimized = c()


for(y in 1:100) {
  gc()
  cat("\n\n", y)
  gurobiIndataFixed$rhs = capVectorFixed
  gurobiIndataScaling$rhs = capVectorScaling
  gurobiIndataOptimize$rhs = capVectorOptimized

  resultFixed = gurobi(gurobiIndataFixed, params)
  gc()
  resultScaling = gurobi(gurobiIndataScaling, params)
  gc()
  resultOptimized = gurobi(gurobiIndataOptimize, params)
  gc()

  maxVectorFixed = c(maxVectorFixed, resultFixed$objval)
  maxVectorScaling = c(maxVectorScaling, resultScaling$objval)
  maxVectorOptimized = c(maxVectorOptimized, resultOptimized$objval)

  cat("\nObj fixed: ", resultFixed$objval)
  cat("\nObj scaling: ", resultScaling$objval)
  cat("\nObj optimized: ", resultOptimized$objval)
   
  incrementedCellIdsFixed = c()
  incrementedCellIdsScaling = c()
  incrementedCellIdOptimized = c()

  x1 = resultScaling$x[1]
  x2 = resultScaling$x[2]
  x3 = resultScaling$x[3]
  x4 = resultScaling$x[4]
  x5 = resultScaling$x[5]
  x6 = resultScaling$x[6]

  scalingRestrictionsVector = c()
  if(x1 == 0) {
    scalingRestrictionsVector = c(1,0,0,0,0,0)
  } else if (x2 != 0) {
    scalingRestrictionsVector = c(1/x1,-1/x2,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(1/x1,0,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(0,0,0,0,0,0)
  }

  if(x2 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector, 0,0,0,0,0,0)
  }


  if(x3 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x4 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1/x4,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1/x4,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x5 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,1,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,1/x5,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x6 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,0,1)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }

  scalingRestrictionsMatrix <- matrix(scalingRestrictionsVector,
  ncol=6,byrow=T)
  if(y == 1) {
    gurobiIndataScaling$A = rbind(as.matrix(indata[,4:9]),
    scalingRestrictionsMatrix)
    size = nrow(gurobiIndataScaling$A) - nrow(scalingRestrictionsMatrix)
    capVectorScaling = c(capVectorScaling, rep(0,6))
    gurobiIndataScaling$sense = c(rep("<=", size), rep("=",6))
  } else {
    size = dim(gurobiIndataScaling$A)[1]
    gurobiIndataScaling$A = rbind(gurobiIndataScaling$
    A[1:(size-nrow(scalingRestrictionsMatrix)),],
    scalingRestrictionsMatrix)
  }

  fixedUpgraded = FALSE
  scalingUpgraded = FALSE
  optimizedUpgraded = FALSE
  for(i in 1:length(uniqeUserId)) {
    firstOffset = 2016 * (i-1) + 1
    lastOffset = 2016 * i
    subsetResultFixed = resultFixed$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResultFixed) && !fixedUpgraded) {
      capVectorFixed[firstOffset:lastOffset] = 
      capVectorFixed[firstOffset] * incrementFactor
      upgradedFixed = as.character(indata[firstOffset, 2])
      incrementedCellIdsFixed = c(incrementedCellIdsFixed, i)
      fixedUpgraded = TRUE
    }
    subsetResultScaling = resultScaling$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResultScaling) && !scalingUpgraded) {
      capVectorScaling[firstOffset:lastOffset] = 
      capVectorScaling[firstOffset] * incrementFactor
      incrementedCellIdsScaling = c(incrementedCellIdsScaling, i)
      upgradedScaling = as.character(indata[firstOffset, 2])
      scalingUpgraded = TRUE
    }
    subsetResultOptimized = resultOptimized$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResultOptimized) && !optimizedUpgraded) {
      capVectorOptimized[firstOffset:lastOffset] = 
      capVectorOptimized[firstOffset] * incrementFactor
      incrementedCellIdOptimized = c(incrementedCellIdOptimized, i)
      upgradedOptimized = as.character(indata[firstOffset, 2])
      optimizedUpgraded = TRUE
    }
    if(fixedUpgraded && scalingUpgraded && optimizedUpgraded) {
      break
    }
  }
  numberOfIncrementedFixed = c(numberOfIncrementedFixed, 
  length(incrementedCellIdsFixed))
  numberOfIncrementedScaling = c(numberOfIncrementedScaling, 
  length(incrementedCellIdsScaling))
  numberOfIncrementedOptimized = c(numberOfIncrementedOptimized, 
  length(incrementedCellIdOptimized))

  #cat("\nUpgraded fixed: ",upgradedFixed)
  #cat("\nUpgraded scaling: ",upgradedScaling)
  #cat("\nUpgraded optimized: ",upgradedOptimized)
  dfCellUpgraded[y,1] = upgradedFixed
  dfCellUpgraded[y,2] = upgradedScaling
  dfCellUpgraded[y,3] = upgradedOptimized

  #cat("\nX-values fixed: ",resultFixed$x)
  #cat("\nX-values scaling: ",resultScaling$x)
  #cat("\nX-values optimized: ",resultOptimized$x)

  #Generate black line that is tetris of green line (no restrictions)
  gurobiOptimize$rhs = head(capVectorScaling, length(capVectorScaling)-6)
  resultOptimized = gurobi(gurobiOptimize, params)
  gc()
  optimizedScalingX = c(optimizedScalingX, sum(numberOfIncrementedScaling))
  optimizedScalingY = c(optimizedScalingY, resultOptimized$obj)


  
  if(y%%2 == 0) {
    gurobiOptimize$rhs = head(capVectorFixed, length(capVectorFixed)-5)
    resultOptimized = gurobi(gurobiOptimize, params)
    gc()
    #cat("\nFixed x-values: ", resultOptimized$x)
    optimizedFixedX = c(optimizedFixedX, sum(numberOfIncrementedFixed))
    optimizedFixedY = c(optimizedFixedY, resultOptimized$obj)

    #cat("\nFixed: ", optimizedFixedX, optimizedFixedY)
    #cat("\nScaling: ", optimizedScalingX, optimizedScalingY)
  }
    gc()
}

gurobiIndataFixed$rhs = capVectorFixed
gurobiIndataScaling$rhs = capVectorScaling
gurobiOptimize$rhs = capVectorOptimized

resultFixed = gurobi(gurobiIndataFixed, params)
resultScaling = gurobi(gurobiIndataScaling, params)
resultOptimized = gurobi(gurobiOptimize, params)

maxVectorFixed = c(maxVectorFixed, resultFixed$objval)
maxVectorScaling = c(maxVectorScaling, resultScaling$objval)
maxVectorOptimized = c(maxVectorOptimized, resultOptimized$objval)

gurobiOptimize$rhs = head(capVectorScaling, length(capVectorScaling)-6)
resultOptimized = gurobi(gurobiOptimize, params)
optimizedScalingX = c(optimizedScalingX, sum(numberOfIncrementedScaling))
optimizedScalingY = c(optimizedScalingY, resultOptimized$obj)

xValuesFixed = c(0)
for(i in 1:length(numberOfIncrementedFixed)) {
  xValuesFixed = c(xValuesFixed, sum(head(numberOfIncrementedFixed,i)))
}
xValuesScaling = c(0)
for(i in 1:length(numberOfIncrementedScaling)) {
  xValuesScaling = c(xValuesScaling, sum(head(numberOfIncrementedScaling,i)))
}
xValuesOptimized = c(0)
for(i in 1:length(numberOfIncrementedOptimized)) {
  xValuesOptimized = c(xValuesOptimized, 
  sum(head(numberOfIncrementedOptimized,i)))
}

dfFixed = data.frame(xValuesFixed, maxVectorFixed)
dfScaling = data.frame(xValuesScaling, maxVectorScaling)
dfOptimized = data.frame(xValuesOptimized, maxVectorOptimized)
dfOptimizedFixed = data.frame(optimizedFixedX, optimizedFixedY)
dfOptimizedScaling = data.frame(optimizedScalingX, optimizedScalingY)

name = "optimizedPlot"
counter = 0

maxValue = max(dfFixed$maxVectorFixed, dfScaling$maxVectorScaling,
dfOptimized$maxVectorOptimized, dfOptimizedFixed$optimizedFixedY,
dfOptimizedScaling$optimizedScalingY) + 1000

maxOptimizedScaling = pmax(maxVectorOptimized, optimizedScalingY)
dfBlueBlack = data.frame(xValuesOptimized, maxOptimizedScaling)

cat("Max y values: ", maxOptimizedScaling)
cat("\n\nX values: ", xValuesFixed)


while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfBlueBlack, type="s", col="darkviolet")
dev.off()


while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfScaling, type="s", col="green")
lines(dfOptimized, type="s", col="blue")
dev.off()

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfScaling, type="s", col="green")
lines(dfOptimized, type="s", col="blue")
lines(dfOptimizedScaling, type="s", col="black")
dev.off()

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfOptimizedScaling, xlab = "", ylab = "", type="s", ylim =c(0, maxValue),
col="black")
dev.off()

xDots = c()
yDots = c()
#Filter only every second dot for plot
for (i in seq(2,length(optimizedScalingX),2)) {
	yDots = c(yDots, optimizedScalingY[i])
	xDots = c(xDots, i)
}

greenDots = data.frame(xDots, yDots)
while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
points(dfOptimizedFixed, col="red", cex=0.5)
lines(dfScaling, type="s", col="green")
points(greenDots, col="green", cex=0.5)
dev.off()

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfScaling, type="s", col="green")
points(dfOptimizedFixed, col="red", cex=0.5)
dev.off()


while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0,maxValue), col="red")
dev.off()

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 3200, height = 3200, units="px", res = 800)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfScaling, type="s", col="green")
dev.off()


data = data.frame(dfCellUpgraded)
write.table(data, paste(versionFolder, "expandedCells.txt", sep=""))

un = union(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nUnion fixed,scaling", length(un))
cat("\nUnion fixed,optimized", length(union(dfCellUpgraded[,1], 
dfCellUpgraded[,3])))
cat("\nUnion scaling,optimized", length(union(dfCellUpgraded[,2], 
dfCellUpgraded[,3])))
un = union(un, dfCellUpgraded[,3])
cat("\nUnion fixed,scaling,optimized", length(un))

inter = intersect(dfCellUpgraded[,1], dfCellUpgraded[,2])
cat("\n\nIntersect fixed,scaling", length(inter))
cat("\nIntersect fixed,optimized", length(intersect(dfCellUpgraded[,1], 
dfCellUpgraded[,3])))
cat("\nIntersect scaling,optimized", length(intersect(dfCellUpgraded[,2], 
dfCellUpgraded[,3])))
inter = intersect(inter, dfCellUpgraded[,3])

uniq = unique(dfCellUpgraded[,1])
cat("\n\nUnique fixed: ", length(uniq))
uniq = unique(dfCellUpgraded[,2])
cat("\n\nUnique scaling: ", length(uniq))
uniq = unique(dfCellUpgraded[,3])
cat("\n\nUnique optimized: ", length(uniq))

