library(slam)
library(gurobi)
library(ggplot2)

# Set working directory
setwd('')

#Settings for full dataset
incrementFactor = 1.5
startCap = 170
versionFolder = "../R_Output_V5/"
userCountVector = c(139, 5805, 5913, 4003, 6057, 5093)


indata = read.csv("../output/segmentMatrixV5_10_min.csv", head = TRUE, sep = ",")
indata = indata[complete.cases(indata), ]
uniqeUserId = unique(indata[,2])

noScalingRestrictionsVector = c(1,-1,0,0,0,0,0,1,-1,0,0,0,0,0,1,-1,
0,0,0,0,0,1,-1,0,0,0,0,0,1,-1)
noScalingRestrictionsMatrix = matrix(noScalingRestrictionsVector,nrow=5,
ncol=6,byrow=T)
noScalingRestrictionsRHSaddition = c(0,0,0,0,0)
sense_additional = c('=','=','=','=','=')

#Red line in figures is all variables labled with Fixed
numberOfIncrementedFixed = c()
maxVectorFixed = c()
gurobiIndataFixed = list()
gurobiIndataFixed$obj = userCountVector
gurobiIndataFixed$modelsense = "max"
gurobiIndataFixed$A = rbind(as.matrix(indata[,c(4,5,6,7,9,10)]), 
noScalingRestrictionsMatrix)
size = nrow(gurobiIndataFixed$A) - nrow(noScalingRestrictionsMatrix)
capVectorFixed = c(rep(startCap, size), noScalingRestrictionsRHSaddition)
gurobiIndataFixed$sense = c(rep("<=", size), sense_additional)

#Green line in figures is all variables labled with Scaling
numberOfIncrementedScaling = c()
maxVectorScaling = c()
gurobiIndataScaling = list()
gurobiIndataScaling$obj = userCountVector
gurobiIndataScaling$modelsense = "max"
gurobiIndataScaling$A = as.matrix(indata[,c(4,5,6,7,9,10)])
size = nrow(gurobiIndataScaling$A)
capVectorScaling = rep(startCap, size)    
gurobiIndataScaling$sense = rep("<=", size)

#Blue line in figures is all variables labled with Optimized
gurobiOptimize = gurobiIndataScaling
gurobiIndataOptimize = gurobiIndataScaling
numberOfIncrementedOptimized = c()
maxVectorOptimized = c()
capVectorOptimized = rep(startCap, size)

optimizedFixedY = c()
optimizedFixedX = c()

optimizedScalingY = c()
optimizedScalingX = c()

params = list(OutputFlag=0)
dfCellUpgraded = matrix(nrow = 100, ncol = 3)

incrementedDayTimeFixed = c()
incrementedDayTimeScaling = c()
incrementedDayTimeOptimized = c()

x_values_fixed = data.frame(x1=numeric(0), x2=numeric(0), x3=numeric(0), x4=numeric(0), x5=numeric(0), x6=numeric(0))
x_values_scaling = data.frame(x1=numeric(0), x2=numeric(0), x3=numeric(0), x4=numeric(0), x5=numeric(0), x6=numeric(0))
x_values_optimized = data.frame(x1=numeric(0), x2=numeric(0), x3=numeric(0), x4=numeric(0), x5=numeric(0), x6=numeric(0))

time_fixed = c()
time_scaling = c()
time_optimized = c()


for(y in 1:100) {
  gc()
  cat("\n\n", y)
  gurobiIndataFixed$rhs = capVectorFixed
  gurobiIndataScaling$rhs = capVectorScaling
  #gurobiIndataOptimize$rhs = capVectorOptimized

  ptm <- proc.time()
  resultFixed = gurobi(gurobiIndataFixed, params)
  time_fixed = c(time_fixed, proc.time()[1] - ptm[1])
  gc()
  
  ptm <- proc.time()
  resultScaling = gurobi(gurobiIndataScaling, params)
  time_scaling = c(time_scaling, proc.time()[1] - ptm[1])
  gc()
  
  #ptm <- proc.time()
  #resultOptimized = gurobi(gurobiIndataOptimize, params)
  #time_optimized = c(time_optimized, proc.time()[1] - ptm[1])
  #gc()

  x_values_fixed = rbind(x_values_fixed, resultFixed$x)
  x_values_scaling = rbind(x_values_scaling, resultScaling$x)
  #x_values_optimized = rbind(x_values_optimized, resultOptimized$x)
  
  maxVectorFixed = c(maxVectorFixed, resultFixed$objval)
  maxVectorScaling = c(maxVectorScaling, resultScaling$objval)
  #maxVectorOptimized = c(maxVectorOptimized, resultOptimized$objval)

  cat("\nObj fixed: ", resultFixed$objval)
  cat("\nObj scaling: ", resultScaling$objval)
  #cat("\nObj optimized: ", resultOptimized$objval)
   
  incrementedCellIdsFixed = c()
  incrementedCellIdsScaling = c()
  #incrementedCellIdOptimized = c()

  x1 = resultScaling$x[1]
  x2 = resultScaling$x[2]
  x3 = resultScaling$x[3]
  x4 = resultScaling$x[4]
  x5 = resultScaling$x[5]
  x6 = resultScaling$x[6]

  scalingRestrictionsVector = c()
  if(x1 == 0) {
    scalingRestrictionsVector = c(1,0,0,0,0,0)
  } else if (x2 != 0) {
    scalingRestrictionsVector = c(1/x1,-1/x2,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(1/x1,0,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(1/x1,0,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(0,0,0,0,0,0)
  }

  if(x2 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1,0,0,0,0)
  } else if (x3 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,-1/x3,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,1/x2,0,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector, 0,0,0,0,0,0)
  }


  if(x3 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1,0,0,0)
  } else if (x4 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,-1/x4,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,0,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,1/x3,0,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x4 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1,0,0)
  } else if (x5 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1/x4,-1/x5,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,1/x4,0,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x5 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,1,0)
  } else if (x6 != 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,1/x5,-1/x6)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }


  if(x6 == 0) {
    scalingRestrictionsVector = c(scalingRestrictionsVector,
    0,0,0,0,0,1)
  } else {
    scalingRestrictionsVector = c(scalingRestrictionsVector,0,0,0,0,0,0)
  }

  scalingRestrictionsMatrix <- matrix(scalingRestrictionsVector, ncol=6, byrow=T)
  if(y == 1) {
    gurobiIndataScaling$A = rbind(as.matrix(indata[,c(4,5,6,7,9,10)]),
    scalingRestrictionsMatrix)
    size = nrow(gurobiIndataScaling$A) - nrow(scalingRestrictionsMatrix)
    capVectorScaling = c(capVectorScaling, rep(0,6))
    gurobiIndataScaling$sense = c(rep("<=", size), rep("=",6))
  } else {
    size = dim(gurobiIndataScaling$A)[1]
    gurobiIndataScaling$A = rbind(gurobiIndataScaling$
    A[1:(size-nrow(scalingRestrictionsMatrix)),],
    scalingRestrictionsMatrix)
  }

  fixedUpgraded = FALSE
  scalingUpgraded = FALSE
  optimizedUpgraded = TRUE
  for(i in 1:length(uniqeUserId)) {
    firstOffset = 2016 * (i-1) + 1
    lastOffset = 2016 * i
    subsetResultFixed = resultFixed$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResultFixed) && !fixedUpgraded) {
      capVectorFixed[firstOffset:lastOffset] = 
      capVectorFixed[firstOffset] * incrementFactor
      upgradedFixed = as.character(indata[firstOffset, 2])
      incrementedCellIdsFixed = c(incrementedCellIdsFixed, i)
      fixedUpgraded = TRUE
    }
    subsetResultScaling = resultScaling$slack[firstOffset:lastOffset]
    if(is.element(0, subsetResultScaling) && !scalingUpgraded) {
      capVectorScaling[firstOffset:lastOffset] = 
      capVectorScaling[firstOffset] * incrementFactor
      incrementedCellIdsScaling = c(incrementedCellIdsScaling, i)
      upgradedScaling = as.character(indata[firstOffset, 2])
      scalingUpgraded = TRUE
    }

    if(fixedUpgraded && scalingUpgraded && optimizedUpgraded) {
      break
    }
  }
  numberOfIncrementedFixed = c(numberOfIncrementedFixed, length(incrementedCellIdsFixed))
  numberOfIncrementedScaling = c(numberOfIncrementedScaling, length(incrementedCellIdsScaling))
  #numberOfIncrementedOptimized = c(numberOfIncrementedOptimized, length(incrementedCellIdOptimized))

  #cat("\nUpgraded fixed: ",upgradedFixed)
  #cat("\nUpgraded scaling: ",upgradedScaling)
  #cat("\nUpgraded optimized: ",upgradedOptimized)
  dfCellUpgraded[y,1] = upgradedFixed
  dfCellUpgraded[y,2] = upgradedScaling
  #dfCellUpgraded[y,3] = upgradedOptimized

  cat("\nX-values fixed: ", resultFixed$x)
  cat("\nX-values scaling: ", resultScaling$x)
  #cat("\nX-values optimized: ",resultOptimized$x)

  gc()
}

gurobiIndataFixed$rhs = capVectorFixed
gurobiIndataScaling$rhs = capVectorScaling
#gurobiOptimize$rhs = capVectorOptimized

gc()
resultFixed = gurobi(gurobiIndataFixed, params)
gc()
resultScaling = gurobi(gurobiIndataScaling, params)
gc()
#resultOptimized = gurobi(gurobiOptimize, params)
#gc()

maxVectorFixed = c(maxVectorFixed, resultFixed$objval)
maxVectorScaling = c(maxVectorScaling, resultScaling$objval)
#maxVectorOptimized = c(maxVectorOptimized, resultOptimized$objval)

x_values_fixed = rbind(x_values_fixed, resultFixed$x)
x_values_scaling = rbind(x_values_scaling, resultScaling$x)
#x_values_optimized = rbind(x_values_optimized, resultOptimized$x)

xValuesFixed = c(0)
for(i in 1:length(numberOfIncrementedFixed)) {
  xValuesFixed = c(xValuesFixed, sum(head(numberOfIncrementedFixed,i)))
}
xValuesScaling = c(0)
for(i in 1:length(numberOfIncrementedScaling)) {
  xValuesScaling = c(xValuesScaling, sum(head(numberOfIncrementedScaling,i)))
}

dfFixed = data.frame(xValuesFixed, maxVectorFixed)
dfScaling = data.frame(xValuesScaling, maxVectorScaling)

name = "optimizedPlot"
counter = 0


maxValue = max(dfFixed$maxVectorFixed, dfScaling$maxVectorScaling) + 1000

while(file.exists(name) | counter == 0) {
  name = paste(versionFolder, "optimizedPlot", counter, ".tiff", sep = "")
  counter = counter + 1
}
tiff(filename = name, width = 1200, height = 1200, units="px", res = 300)
plot(dfFixed, xlab = "", ylab = "", type="s", ylim =c(0, maxValue), col="red")
lines(dfScaling, type="s", col="green")
dev.off()